package net.w_horse.excelpojo.excel.reservedword;

import java.util.ArrayList;
import java.util.List;


/**
 * @author kawahara
 */
public class ReservedWordManager {
	private static ReservedWordManager instance;
	private List<ReservedWord> reservedWordList;

	private static ReservedWordManager getInstance() {
		if (instance == null) {
			instance = new ReservedWordManager();
		}
		return instance;
	}

	private ReservedWordManager() {
		reservedWordList = new ArrayList<ReservedWord>();
		reservedWordList.add(new EXEC_DATE_HHMMSS());
		reservedWordList.add(new EXEC_DATE_HP_YMD());
		reservedWordList.add(new EXEC_DATE_SL_YMD());
		reservedWordList.add(new EXEC_DATE_YYYYMMDD());
	}

	/**
	 * \̃XgԂ
	 *
	 * @return \̃Xg
	 */
	private static List<ReservedWord> getReservedWrodList() {
		return getInstance().reservedWordList;
	}

	/**
	 * SQL쐬pɗ\ϊ<br>
	 * T|[gĂ\ׂĕϊ
	 *
	 * @param expr ϊ
	 * @return ϊ
	 */
	public static String convReservedWord(String expr) {
		if( (expr == null) || expr.equals("") ) return "";

		String retStr = expr ;
		for (ReservedWord reservedWord : getReservedWrodList()) {
			if (reservedWord.indexOf(retStr) < 0) {	// \ꂪ݂ĂȂȂ玟
				continue ;
			}
			retStr = reservedWord.replace(retStr) ;
		}
		return retStr;
	}

}
